<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css"
        href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/boxicons@latest/css/boxicons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <script src="{{ asset('rider/main.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('rider/style.css') }}">

    <style>
        /* Initially hide the dropdown content */
        .dropdown-content {
            display: none;
            position: absolute;
            background-color: #f9f9f9;
            min-width: 160px;
            box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
            z-index: 1;
        }

        /* Style the dropdown links */
        .dropdown-content a {
            color: black;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
        }

        /* Change color of links on hover */
        .dropdown-content a:hover {
            background-color: #ddd;
        }

        /* Show the dropdown content when hovering over the user icon */
        #user-dropdown:hover .dropdown-content {
            display: block;
        }

        body#body-pd {
            padding-left: 1% !important;
            padding-left: 2% !important;
        }

        /* Style the odd rows differently for better readability */
        .date {
            background-color: #f9f9f9;
        }

        .table-responsive {
            max-height: 400px;

            overflow-y: auto;
        }
    </style>

</head>

<body id="body-pd">



    <div style="padding-top: 5px; padding-left: 10px; " class="height-100 bg-light ">
        <section id="stats-subtitle">
            <div style="border: cyan;padding-bottom: 20px;" class="row">
                <div class="col-12 col-xl-12 col-sm-12 text-xl-center">
                    <img style="width:150px;" src="{{ asset('images/Lanka_Getaways__1_-removebg-previewBack.png') }}"
                        alt="Lanka Getaways">
                    <h2
                        style="color: cyan;
                        padding-top:20px;
                     font-size: 40px;;
                        font-family: fangsong;
                    ">
                        Lankagetaways</h2>
                    <span style="color: #fff;">No. 86, Station Road,
                        Palangathure,
                        Kochchikade,
                        Sri Lanka,
                        11540</span>

                </div>


            </div>

            <div class="row">
                <div class="col-8">
                    <div id="map" style="height: 500px; width: 100%;margin-bottom:60px;"></div>
                </div>

                <div class="col-4">
                    <div class="card">
                        <div style="padding-bottom: 100px;" class="">

                            <div class="table-responsive">
                                <table class="table" id="dynamic-table">
                                    <tbody>
                                        @foreach ($hotels as $index => $hotel)
                                            <tr class="main-row">
                                            <tr class="date">
                                                <td class="">
                                                    <i class="far fa-clock"></i> {{ $hotel->date }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="min-width-cell">
                                                    @if ($hotel->hotel != null)
                                                        Hotel: {{ $hotel->hotel }} <br>
                                                        Hotel Address: {{ $hotel->h_address }} <br>
                                                        Hotel Contact: {{ $hotel->h_contact }} <br>
                                                    @endif
                                                    <i class="fas fa-map-marker-alt"></i> Destination:
                                                    {{ $hotel->h_place }}<br>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="min-width-cell">
                                                    <i class="far fa-sticky-note"></i> Sp.Note: {{ $hotel->h_note }}
                                                </td>
                                            </tr>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="form-group row">
                                <label for="price" class="col-sm-2 col-form-label">Ride Price
                                    :{{ $job->ride }}</label>



                            </div>








                        </div>
                    </div>
                </div>
            </div>

        </section>
    </div>

    <?php
    $itineraryArray = json_decode($data->itinerary, true);
    $itineraryJSON = json_encode($itineraryArray);
    ?>
    <script>
        var map;
        var directionsService;
        var directionsRenderer;
        var locationNames = <?php echo $itineraryJSON; ?>;

        console.log(locationNames);

        function initMap() {
            map = new google.maps.Map(document.getElementById("map"), {
                zoom: 5,
            });

            directionsService = new google.maps.DirectionsService();
            directionsRenderer = new google.maps.DirectionsRenderer({
                map: map,
            });

            updateDirections();
        }

        function updateDirections() {
            var origin = locationNames[0];
            var destination = locationNames[locationNames.length - 1];
            var waypoints = locationNames.slice(1, -1);

            var waypointsArray = waypoints.map(function(waypoint) {
                return {
                    location: waypoint,
                    stopover: true,
                };
            });

            var request = {
                origin: origin,
                destination: destination,
                waypoints: waypointsArray,
                travelMode: google.maps.TravelMode.DRIVING,
            };

            directionsService.route(request, function(result, status) {
                if (status == google.maps.DirectionsStatus.OK) {
                    directionsRenderer.setDirections(result);
                }
            });
        }
    </script>
    <script>
        function loadScript() {
            var script = document.createElement("script");
            script.src =
                "https://maps.googleapis.com/maps/api/js?key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4&libraries=places&callback=initMap";
            script.async = true;
            document.head.appendChild(script);
        }

        window.onload = loadScript;
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</body>

</html>
